/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.saveddata.models;

import com.dodgeman.shw.saveddata.models.Home;
import com.dodgeman.shw.saveddata.models.Waypoint;
import com.dodgeman.shw.saveddata.models.WaypointName;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class PlayerHomeAndWaypoints {
    private Home home;
    private final HashMap<WaypointName, Waypoint> waypoints;
    private boolean hasAlreadySetWaypoint = false;
    private boolean hasAlreadySetHomeInTheNether;
    private boolean hasAlreadySetHomeInTheEnd;
    private long lastExecutionOfHomeCommand;
    private long lastExecutionOfWaypointUseCommand;
    private Waypoint lastDeletedWaypoint;
    private long lastDeletedWaypointAt = 0L;
    private long undoInformationHasBeenShownAt = 0L;
    private int removeWaypointSuccessMessageIndex = 1;

    public PlayerHomeAndWaypoints() {
        this.waypoints = new HashMap();
    }

    public PlayerHomeAndWaypoints(Home home, List<Waypoint> waypoints, boolean hasAlreadySetWaypoint, boolean hasAlreadySetHomeInTheNether, boolean hasAlreadySetHomeInTheEnd, long lastExecutionOfHomeCommand, long lastExecutionOfWaypointUseCommand, Waypoint lastDeletedWaypoint, long lastDeletedWaypointAt, long undoInformationHasBeenShowAt, int removeWaypointSuccessMessageIndex) {
        this.home = home;
        this.waypoints = new HashMap();
        this.hasAlreadySetWaypoint = hasAlreadySetWaypoint;
        this.hasAlreadySetHomeInTheNether = hasAlreadySetHomeInTheNether;
        this.hasAlreadySetHomeInTheEnd = hasAlreadySetHomeInTheEnd;
        this.lastExecutionOfHomeCommand = lastExecutionOfHomeCommand;
        this.lastExecutionOfWaypointUseCommand = lastExecutionOfWaypointUseCommand;
        this.lastDeletedWaypoint = lastDeletedWaypoint;
        this.lastDeletedWaypointAt = lastDeletedWaypointAt;
        this.undoInformationHasBeenShownAt = undoInformationHasBeenShowAt;
        this.removeWaypointSuccessMessageIndex = removeWaypointSuccessMessageIndex;
        waypoints.forEach(waypoint -> this.waypoints.put(waypoint.name(), (Waypoint)waypoint));
    }

    public void setNewHome(Home newHome) {
        this.home = newHome;
        if (this.home.position().isInTheNether()) {
            this.hasAlreadySetHomeInTheNether = true;
        }
        if (this.home.position().isInTheEnd()) {
            this.hasAlreadySetHomeInTheEnd = true;
        }
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypoints.put(waypoint.name(), waypoint);
        this.hasAlreadySetWaypoint = true;
        this.clearLastDeletedWaypoint();
    }

    public boolean hasWaypointNamed(WaypointName name) {
        return this.waypoints.containsKey(name);
    }

    public Waypoint getWaypointByName(WaypointName name) {
        return this.waypoints.get(name);
    }

    public void removeWaypoint(WaypointName name) {
        this.lastDeletedWaypoint = this.waypoints.remove(name);
        this.lastDeletedWaypointAt = new Date().getTime();
    }

    public void undoLastDeletedWaypoint() {
        this.waypoints.put(this.lastDeletedWaypoint.name(), this.lastDeletedWaypoint);
        this.clearLastDeletedWaypoint();
    }

    public void undoInformationHasBeenShown() {
        this.undoInformationHasBeenShownAt = new Date().getTime();
    }

    public void clearWaypoints() {
        this.waypoints.clear();
        this.clearLastDeletedWaypoint();
    }

    public void waypointUseCommandHasBeenExecuted() {
        this.lastExecutionOfWaypointUseCommand = new Date().getTime();
        this.clearLastDeletedWaypoint();
    }

    public void clearLastDeletedWaypoint() {
        this.lastDeletedWaypoint = null;
    }

    public long elapsedTimeOfWaypointUseCommandExecution() {
        return new Date().getTime() - this.lastExecutionOfWaypointUseCommand;
    }

    public void homeCommandHasBeenExecuted() {
        this.lastExecutionOfHomeCommand = new Date().getTime();
    }

    public long elapsedTimeOfLastHomeCommandExecution() {
        return new Date().getTime() - this.lastExecutionOfHomeCommand;
    }

    public void updateRemoveWaypointSuccessMessageIndex(int nbRemoveWaypointSuccessMessage) {
        if (this.removeWaypointSuccessMessageIndex < nbRemoveWaypointSuccessMessage) {
            ++this.removeWaypointSuccessMessageIndex;
            return;
        }
        this.removeWaypointSuccessMessageIndex = 1;
    }

    public Home getHome() {
        return this.home;
    }

    public HashMap<WaypointName, Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public int getNbOfWaypoints() {
        return this.waypoints.values().size();
    }

    public boolean hasAlreadySetWaypoint() {
        return this.hasAlreadySetWaypoint;
    }

    public boolean hasAlreadySetHomeInTheNether() {
        return this.hasAlreadySetHomeInTheNether;
    }

    public boolean hasAlreadySetHomeInTheEnd() {
        return this.hasAlreadySetHomeInTheEnd;
    }

    public long getLastExecutionOfHomeCommand() {
        return this.lastExecutionOfHomeCommand;
    }

    public long getLastExecutionOfWaypointUseCommand() {
        return this.lastExecutionOfWaypointUseCommand;
    }

    public Waypoint getLastDeletedWaypoint() {
        return this.lastDeletedWaypoint;
    }

    public boolean hasLastDeletedWaypoint() {
        return this.lastDeletedWaypoint != null;
    }

    public List<WaypointName> getWaypointsName() {
        return this.waypoints.keySet().stream().toList();
    }

    public long getLastDeletedWaypointAt() {
        return this.lastDeletedWaypointAt;
    }

    public long getUndoInformationHasBeenShownAt() {
        return this.undoInformationHasBeenShownAt;
    }

    public int getRemoveWaypointSuccessMessageIndex() {
        return this.removeWaypointSuccessMessageIndex;
    }
}

